package com.bxm.mcssp.common.enums;

/**
 * 开发者财务，应用，广告的审核状态枚举
 * Created by zhengwangeng 2019/07/25
 */
public enum AuditResultsEnum {

    //2：终审拒绝 1：终审通过, 0：风控终审, 3：媒介初审, 4：初审拒绝
    /**
     * 审核流程
     * 3-0-2
     * 3-0-1
     * 3-4
     */

    WAITING(0, "风控终审"),

    PASS(1, "终审通过"),

    REFUSE(2, "终审拒绝"),

    FIRST_PASS(3, "媒体初审"),

    FIRST_REFUSE(4, "初审拒绝");

    private Integer status;

    private String desc;

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    AuditResultsEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }
    
    public static AuditResultsEnum get(Integer status) {
        if (null == status) {
            return null;
        }
        for (AuditResultsEnum anEnum : values()) {
            if (anEnum.getStatus().equals(status)) {
                return anEnum;
            }
        }
        return null;
    }
}
