package com.bxm.mcssp.common.enums.position;

/**
 * <p>
 * 信息流模板
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-03-03
 */
public enum InformationFlowTemplateEnum {

    /**
     * 上图下文
     */
    ONE(1, "上图下文"),

    /**
     * 下图上文
     */
    TWO(2, "下图上文"),

    /**
     * 左图右文
     */
    THREE(3, "左图右文"),

    /**
     * 左文右图
     */
    FOUR(4, "左文右图"),

    /**
     * 双图双文
     */
    FIVE(5, "双图双文"),

    /**
     * 组图（三张图）
     */
    SIX(6, "组图（三张图）"),

    /**
     * 文字浮层（上图下文）
     */
    SEVEN(7, "文字浮层（上图下文）"),

    /**
     * 文字浮层（上文下图）
     */
    EIGHT(8, "文字浮层（上文下图）"),

    /**
     * 文字浮层（单图）
     */
    NINE(9, "文字浮层（单图）"),

    /**
     * 横版纯图（大图）
     */
    TEN(10, "横版纯图（大图）"),

    /**
     * 竖图（竖图）
     */
    ELEVEN(11, "竖图")
    ;

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    InformationFlowTemplateEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static InformationFlowTemplateEnum get(Integer type) {
        if (null == type) {
            return null;
        }
        for (InformationFlowTemplateEnum anEnum : values()) {
            if (anEnum.getType().equals(type)) {
                return anEnum;
            }
        }
        return null;
    }
}
