package com.bxm.mcssp.common.enums.position;

/**
 * <p>
 * 广告位SDK配置渠道枚举
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-1-7
 */
public enum PositionSdkConfigChannelEnum {

    /**
     * 这里走的是流量分配
     */
    BXM("bxm_channel", "变现猫"),

    CSJ("csj_channel", "穿山甲"),

    MOBVISTA("mobvista_channel", "mobvista"),

    GDT("gdt_channel", "广点通"),

    BD("bd_channel", "百度"),

    APP("app_channel", "本地客户端"),

    KS("ks_channel", "快手"),

    AD("ad_channel", "爱豆"),

    QM("qm_channel", "趣盟"),

    /**
     * 这里是所有的渠道都取不到数据的时候才有用
     */
    BACKUP("backup_channel", "变现猫兜底"),

    /**
     * 这里是聚合广告位才有的，用在广告位收益的具体渠道收益上，用于计算子广告位的汇总数据
     */
    COLLECTION("collection_total", "聚合汇总"),
    ;


    private String code;

    private String name;

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    PositionSdkConfigChannelEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static PositionSdkConfigChannelEnum get(String code) {
        if (null == code) {
            return null;
        }
        for (PositionSdkConfigChannelEnum anEnum : values()) {
            if (anEnum.getCode().equals(code)) {
                return anEnum;
            }
        }
        return null;
    }

    public static PositionSdkConfigChannelEnum getByName(String name) {
        if (null == name) {
            return null;
        }
        for (PositionSdkConfigChannelEnum anEnum : values()) {
            if (anEnum.getName().equals(name)) {
                return anEnum;
            }
        }
        return null;
    }
}
