package com.bxm.mcssp.facade.model;

import java.io.Serializable;
import java.util.List;

import org.apache.poi.ss.formula.functions.T;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import lombok.Data;

/**
 * <p>
 * 分页参数对象
 * 这里其实就是MyBatisPlus里的Page对象，只不过是只定义了需要的三个参数
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-25
 */
@Data
public class PageDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    private long size = 20;
    private long current = 1;
    private List<OrderItem> orders;

    /**
     * 获取mybatisPlus封装的Page对象
     *
     * @return
     */
    public Page<T> getPage() {
        Page page = new Page();
        page.setCurrent(this.current);
        page.setSize(this.size);
        page.setOrders(orders);
        return page;
    }
}
