package com.bxm.mcssp.facade.model.position;

import java.io.Serializable;

import com.bxm.mcssp.facade.model.PageDTO;

import lombok.Data;

/**
 * <p>
 * 编辑,查询广告位组件
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-02-11
 */
@Data
public class PositionAssemblyFacadeQueryDTO extends PageDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final int FALLBACK_STRATEGY_NONE = 1;

    public static final int FALLBACK_STRATEGY_ASSEMBLY = 2;

    /**
     * 广告位ID,名称
     */
    private String positionKeyword;

    /**
     * 媒体运营
     */
    private String mjCode;

    /**
     * 是否配置组件：0未配置，1已配置
     */
    private Integer configFlag;

    /**
     * 兜底策略：1无兜底，2组件兜底
     */
    private Integer fallbackStrategy;

    /**
     * 是否已关闭：1 表示已关闭，0 表示未关闭
     */
    private Integer closedFlag;

}
