/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.alicloud.amqp;

import com.bxm.newidea.component.alicloud.amqp.AliyunCredentialsProvider;
import com.bxm.newidea.component.alicloud.amqp.AmqpProperties;
import com.rabbitmq.client.impl.CredentialsProvider;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"alicloud.amqp.instanceId"})
public class AliCloudAmqpConfiguration {
    @Autowired
    private AmqpProperties amqpProperties;

    @Bean
    public ConnectionFactory getConnectionFactory(RabbitProperties rabbitProperties) {
        com.rabbitmq.client.ConnectionFactory rabbitConnectionFactory = new com.rabbitmq.client.ConnectionFactory();
        rabbitConnectionFactory.setHost(rabbitProperties.getHost());
        rabbitConnectionFactory.setPort(rabbitProperties.getPort().intValue());
        rabbitConnectionFactory.setVirtualHost(rabbitProperties.getVirtualHost());
        AliyunCredentialsProvider credentialsProvider = new AliyunCredentialsProvider(rabbitProperties.getUsername(), rabbitProperties.getPassword(), this.amqpProperties.getInstanceId());
        rabbitConnectionFactory.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        rabbitConnectionFactory.setNetworkRecoveryInterval(5000);
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(rabbitConnectionFactory);
        connectionFactory.setPublisherConfirmType(CachingConnectionFactory.ConfirmType.NONE);
        connectionFactory.setPublisherReturns(rabbitProperties.isPublisherReturns());
        return connectionFactory;
    }
}

