/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.oss.service.impl;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sts.model.v20150401.AssumeRoleRequest;
import com.aliyuncs.sts.model.v20150401.AssumeRoleResponse;
import com.bxm.newidea.component.oss.config.AliyunOssTokenProperties;
import com.bxm.newidea.component.oss.dto.OSSToken;
import com.bxm.newidea.component.oss.service.AliyunOssTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AliyunOssTokenServiceImpl
implements AliyunOssTokenService {
    private static final Logger logger = LoggerFactory.getLogger(AliyunOssTokenServiceImpl.class);
    private AliyunOssTokenProperties aliyunOssTokenProperties;

    @Autowired
    public AliyunOssTokenServiceImpl(AliyunOssTokenProperties aliyunOssTokenProperties) {
        this.aliyunOssTokenProperties = aliyunOssTokenProperties;
    }

    @Override
    public OSSToken getOssToken() {
        try {
            AssumeRoleResponse response = (AssumeRoleResponse)this.getDafaultAcsClient().getAcsResponse((AcsRequest)this.assumeRole());
            return new OSSToken(response.getCredentials().getSecurityToken(), response.getCredentials().getAccessKeySecret(), response.getCredentials().getAccessKeyId());
        }
        catch (ClientException e) {
            logger.error("\u83b7\u53d6oss\u3002\u3002\u3002token\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private AssumeRoleRequest assumeRole() {
        AssumeRoleRequest request = new AssumeRoleRequest();
        request.setVersion(this.aliyunOssTokenProperties.getStsApiVersion());
        request.setMethod(MethodType.POST);
        request.setProtocol(ProtocolType.HTTPS);
        request.setRoleArn(this.aliyunOssTokenProperties.getRoleArn());
        request.setRoleSessionName(this.aliyunOssTokenProperties.getRoleSessionName());
        request.setPolicy(this.aliyunOssTokenProperties.getPolicy());
        request.setDurationSeconds(Long.valueOf(this.aliyunOssTokenProperties.getTokenExpireTime()));
        return request;
    }

    private DefaultAcsClient getDafaultAcsClient() {
        DefaultProfile profile = DefaultProfile.getProfile((String)this.aliyunOssTokenProperties.getRegion(), (String)this.aliyunOssTokenProperties.getAccessKey(), (String)this.aliyunOssTokenProperties.getAccessSecret());
        return new DefaultAcsClient((IClientProfile)profile);
    }
}

