package com.bxm.newidea.component.oss.constant;

/**
 * 在阿里云oss配置中支持对图片进行后置压缩处理，此处为其中配置的对应的style
 * @author liujia
 */
public class OSSImgProcessType {

    /**
     * 用户头像图片压缩参数
     */
    public static final String HEAD = "head";

    /**
     * 移动端图片压缩
     */
    public static final String MOBILE_COMPRESS = "mcompress";

    /**
     * 图片压缩并添加水印
     */
    public static final String COMPRESS_WITH_WATERMARK = "wcompress";

    /**
     * 服务端进行图片压缩,多用于在运营管理系统中的图片文件上传
     */
    public static final String SERVER_COMPRESS = "scompress";

    /**
     * 视频列表中显示的图片
     */
    public static final String VIDEO_COMPRESS = "video";

    /**
     * 新闻列表中显示的缩略图压缩方式
     */
    public static final String THUMBNAIL = "thumbnail";

    private OSSImgProcessType() {
    }


}
