/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.apollo;

import com.bxm.newidea.component.apollo.i18n.ApolloMessageSource;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.spring.boot.ApolloAutoConfiguration;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySource;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySourceFactory;
import com.ctrip.framework.apollo.spring.util.SpringInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
@AutoConfigureAfter(value={ApolloAutoConfiguration.class})
public class CustomApolloAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CustomApolloAutoConfiguration.class);

    @Bean
    public ApolloMessageSource apolloMessageSource() {
        return new ApolloMessageSource();
    }

    @EventListener(value={ApplicationStartedEvent.class})
    public void initNamespaceListener(ApplicationStartedEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        ConfigPropertySourceFactory configPropertySourceFactory = (ConfigPropertySourceFactory)SpringInjector.getInstance(ConfigPropertySourceFactory.class);
        configPropertySourceFactory.getAllConfigPropertySources().forEach(arg_0 -> CustomApolloAutoConfiguration.lambda$initNamespaceListener$1((ApplicationContext)applicationContext, arg_0));
    }

    private static /* synthetic */ void lambda$initNamespaceListener$1(ApplicationContext applicationContext, ConfigPropertySource config) {
        config.addChangeListener(changeEvent -> {
            for (String key : changeEvent.changedKeys()) {
                ConfigChange change = changeEvent.getChange(key);
                log.info("apollo config change,key:{},old value:{},new value:{}", new Object[]{key, change.getOldValue(), change.getNewValue()});
            }
            applicationContext.publishEvent((ApplicationEvent)new EnvironmentChangeEvent(changeEvent.changedKeys()));
        });
    }
}

