/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.apollo;

import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;

@Component
public class ApolloConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ApolloConfiguration.class);
    private ApplicationContext applicationContext;

    @ApolloConfigChangeListener(value={"application", "LN.common"})
    public void changeHandler(ConfigChangeEvent configChangeEvent) {
        if (log.isDebugEnabled()) {
            for (String key : configChangeEvent.changedKeys()) {
                log.debug("change key : {}", (Object)key);
            }
        }
        this.applicationContext.publishEvent((ApplicationEvent)new EnvironmentChangeEvent(configChangeEvent.changedKeys()));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

