/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component;

import com.bxm.newidea.component.param.BarCodeParam;
import com.bxm.newidea.component.param.QrCodeParam;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.apache.fop.util.UnitConv;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeCreaterFactory {
    private static final int DPI = 150;
    private static Logger logger = LoggerFactory.getLogger(CodeCreaterFactory.class);

    public static void createBarCode(BarCodeParam barCodeParam) {
        AbstractBarcodeBean bean = barCodeParam.getBarCodeTypeEnum().getObject();
        BitmapCanvasProvider canvas = new BitmapCanvasProvider(barCodeParam.getBarCodeOutputStream(), barCodeParam.getBarCodeImageType().getValue(), 150, 12, false, 0);
        bean.setBarHeight((double)barCodeParam.getHeight());
        bean.doQuietZone(false);
        bean.setModuleWidth(UnitConv.in2mm((double)(barCodeParam.getWidth() / 150.0)));
        bean.generateBarcode((CanvasProvider)canvas, barCodeParam.getMessage());
        try {
            canvas.finish();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void createQrCode(QrCodeParam qrCodeParam) {
        MultiFormatWriter writer = new MultiFormatWriter();
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8.name());
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.MARGIN, 0);
        try {
            BitMatrix bitMatrix = writer.encode(qrCodeParam.getMessage(), BarcodeFormat.QR_CODE, qrCodeParam.getWidth(), qrCodeParam.getHeight(), hints);
            if (qrCodeParam.getClearWhite().booleanValue()) {
                bitMatrix = CodeCreaterFactory.clearWhite(bitMatrix);
            }
            if (StringUtils.isEmpty((CharSequence)qrCodeParam.getLogoPath())) {
                CodeCreaterFactory.writerToFileWithOutLogo(bitMatrix, qrCodeParam);
            } else {
                CodeCreaterFactory.writerToFileWithLogo(bitMatrix, qrCodeParam);
            }
        }
        catch (WriterException | IOException e) {
            logger.error(e.getMessage(), e);
        }
    }

    private static void writerToFileWithOutLogo(BitMatrix matrix, QrCodeParam qrCodeParam) throws IOException {
        BufferedImage image = CodeCreaterFactory.toBufferedImage(matrix, qrCodeParam);
        try {
            if (null != qrCodeParam.getResponse()) {
                ImageIO.write((RenderedImage)image, qrCodeParam.getImageTypeEnum().name(), (OutputStream)qrCodeParam.getResponse().getOutputStream());
            } else {
                ImageIO.write((RenderedImage)image, qrCodeParam.getImageTypeEnum().name(), qrCodeParam.getImageFile());
            }
        }
        catch (IOException e) {
            throw new IOException("\u751f\u6210\u56fe\u7247\u5931\u8d25");
        }
    }

    private static void writerToFileWithLogo(BitMatrix matrix, QrCodeParam qrCodeParam) throws IOException {
        BufferedImage image = CodeCreaterFactory.toBufferedImage(matrix, qrCodeParam);
        Graphics2D gs = image.createGraphics();
        int width = qrCodeParam.getWidth() / 4 > 0 ? qrCodeParam.getWidth() / 4 : 1;
        int height = qrCodeParam.getHeight() / 4 > 0 ? qrCodeParam.getHeight() / 4 : 1;
        int positionX = qrCodeParam.getWidth() * 3 / 8;
        int positionY = qrCodeParam.getHeight() * 3 / 8;
        BufferedImage img = CodeCreaterFactory.scale(qrCodeParam.getLogoPath(), width, height);
        gs.drawImage((Image)img, positionX, positionY, null);
        gs.dispose();
        img.flush();
        if (null != qrCodeParam.getResponse()) {
            ImageIO.write((RenderedImage)image, qrCodeParam.getImageTypeEnum().name(), (OutputStream)qrCodeParam.getResponse().getOutputStream());
        } else {
            ImageIO.write((RenderedImage)image, qrCodeParam.getImageTypeEnum().name(), qrCodeParam.getImageFile());
        }
    }

    private static BufferedImage toBufferedImage(BitMatrix matrix, QrCodeParam bean) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? bean.getImageColor() : bean.getBackgroundColor());
            }
        }
        return image;
    }

    private static BufferedImage scale(String srcImageFile, int height, int width) throws IOException {
        double ratio = 0.0;
        File file = new File(srcImageFile);
        BufferedImage srcImage = ImageIO.read(file);
        Image destImage = srcImage.getScaledInstance(width, height, 4);
        if (srcImage.getHeight() > height || srcImage.getWidth() > width) {
            ratio = srcImage.getHeight() > srcImage.getWidth() ? new Integer(height).doubleValue() / (double)srcImage.getHeight() : new Integer(width).doubleValue() / (double)srcImage.getWidth();
            AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
            destImage = op.filter(srcImage, null);
        }
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphic = image.createGraphics();
        graphic.setColor(Color.white);
        graphic.fillRect(0, 0, width, height);
        if (width == destImage.getWidth(null)) {
            graphic.drawImage(destImage, 0, (height - destImage.getHeight(null)) / 2, destImage.getWidth(null), destImage.getHeight(null), Color.white, null);
        } else {
            graphic.drawImage(destImage, (width - destImage.getWidth(null)) / 2, 0, destImage.getWidth(null), destImage.getHeight(null), Color.white, null);
        }
        graphic.dispose();
        destImage = image;
        return (BufferedImage)destImage;
    }

    private static BitMatrix clearWhite(BitMatrix bitMatrix) {
        int[] rec = bitMatrix.getEnclosingRectangle();
        int resWidth = rec[2] + 1;
        int resHeight = rec[3] + 1;
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = 0; i < resWidth; ++i) {
            for (int j = 0; j < resHeight; ++j) {
                if (!bitMatrix.get(i + rec[0], j + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        return bitMatrix;
    }
}

