/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.param;

import com.bxm.newidea.component.config.ImageTypeEnum;
import com.bxm.newidea.component.tools.FileUtils;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class QrCodeParam {
    private static final int MAX_LENGTH = 1817;
    private File imageFile;
    private ImageTypeEnum imageTypeEnum;
    private String message;
    private int width;
    private int height;
    private int backgroundColor;
    private int imageColor;
    private String logoPath;
    private Boolean clearWhite = false;
    private HttpServletResponse response;

    public QrCodeParam() {
        this.width = 100;
        this.height = 100;
        this.imageTypeEnum = ImageTypeEnum.JPEG;
        this.backgroundColor = Color.WHITE.getRGB();
        this.imageColor = Color.black.getRGB();
    }

    public QrCodeParam(String imageFilePath, String message) throws IOException {
        if (StringUtils.isEmpty((String)imageFilePath)) {
            throw new IllegalArgumentException("\u4e8c\u7ef4\u7801\u5b58\u653e\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!FileUtils.checkAndCreateFile((String)imageFilePath)) {
            throw new IOException("\u521b\u5efa\u6587\u4ef6\u5939\u8def\u5f84\u4e0b\u6587\u4ef6\u5931\u8d25");
        }
        if (StringUtils.isEmpty((String)message) || message.length() > 1817) {
            throw new IllegalArgumentException("\u4e8c\u7ef4\u7801\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8d85\u8fc7\u6700\u5927\u503c");
        }
        this.initQrCode(new File(imageFilePath), message);
    }

    public QrCodeParam(File imageFile, String message) throws IOException {
        if (!FileUtils.checkAndCreateFile((File)imageFile)) {
            throw new IOException("\u521b\u5efa\u6587\u4ef6\u5939\u8def\u5f84\u4e0b\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\uff1a" + imageFile.getAbsolutePath());
        }
        if (StringUtils.isEmpty((String)message) || message.length() > 1817) {
            throw new IllegalArgumentException("\u4e8c\u7ef4\u7801\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8d85\u8fc7\u6700\u5927\u503c");
        }
        this.initQrCode(imageFile, message);
    }

    private void initQrCode(File imageFile, String message) {
        this.imageFile = imageFile;
        this.message = message;
        this.width = 100;
        this.height = 100;
        this.imageTypeEnum = ImageTypeEnum.JPEG;
        this.backgroundColor = Color.WHITE.getRGB();
        this.imageColor = Color.black.getRGB();
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(File imageFile) {
        this.imageFile = imageFile;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ImageTypeEnum getImageTypeEnum() {
        return this.imageTypeEnum;
    }

    public void setImageTypeEnum(ImageTypeEnum imageTypeEnum) {
        this.imageTypeEnum = imageTypeEnum;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getImageColor() {
        return this.imageColor;
    }

    public void setImageColor(int imageColor) {
        this.imageColor = imageColor;
    }

    public String getLogoPath() {
        return this.logoPath;
    }

    public void setLogoPath(String logoPath) {
        this.logoPath = logoPath;
    }

    public Boolean getClearWhite() {
        return this.clearWhite;
    }

    public void setClearWhite(Boolean clearWhite) {
        this.clearWhite = clearWhite;
    }
}

