package com.bxm.localnews.common.handler;

import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.exception.BusinessException;
import com.bxm.localnews.common.util.HttpParamUtil;
import com.bxm.localnews.common.vo.Json;

import com.bxm.newidea.component.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;


/**
 * 全局异常处理
 *
 * @author liujia 2018/3/30 21:20
 */
@ControllerAdvice
@ResponseBody
public class CustomizeExceptionHandler {

    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 处理业务异常
     */
    @ExceptionHandler(BusinessException.class)
    public Json handlBusinessException(BusinessException e, HttpServletRequest request) {
        loginError(request);
        logger.error(e.getMessage(), e);
        return Json.build(RespCode.BAD_REQUEST, e.getMessage());
    }

    /**
     * 参数异常
     */
    @ExceptionHandler(IllegalArgumentException.class)
    public Json handlBusinessException(IllegalArgumentException e, HttpServletRequest request) {
        loginError(request);
        logger.error(e.getMessage(), e);
        return Json.build(RespCode.BAD_REQUEST, e.getMessage());
    }

    /**
     * 方法不支持
     */
    @ExceptionHandler(HttpRequestMethodNotSupportedException.class)
    public Json handlBusinessException(HttpRequestMethodNotSupportedException e, HttpServletRequest request) {
        loginError(request);
        logger.error(e.getMessage(), e);
        return Json.build(RespCode.METHOD_NOT_ALLOWED, e.getMessage());
    }

    protected void loginError(HttpServletRequest request) {
        logger.error("request uri:[{}],request param:[{}]", request.getRequestURI(), WebUtils.getReqeustParam(request));
    }

    /**
     * 处理全局异常，当具体的异常类型未匹配时
     */
    @ExceptionHandler(Exception.class)
    public Json handlException(Exception e, HttpServletRequest request) {
        loginError(request);
        logger.error(e.getMessage(), e);
        return Json.build(RespCode.INTERNAL_SERVER_ERROR, "服务器错误");
    }

}
