/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.common.sharding;

import com.bxm.localnews.common.vo.IProvicneSharding;
import com.google.code.shardbatis.strategy.ShardStrategy;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvinceStrategy
implements ShardStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProvinceStrategy.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTargetTableName(String baseTableName, Object params, String mapperId) {
        if (params instanceof IProvicneSharding) {
            IProvicneSharding sharding = (IProvicneSharding)params;
            if (sharding.getProvince() != null && sharding.getProvince() != 0L) return this.getTableName(sharding.getProvince(), baseTableName);
            LOGGER.error("\u6839\u636eprovince\u8fdb\u884c\u5206\u8868\uff0c\u5fc5\u987b\u6709\u503c\uff0c\u5b9e\u9645\u503c\u662f0");
            return baseTableName;
        } else {
            if (params instanceof Long) {
                return this.getTableName((Long)params, baseTableName);
            }
            if (params instanceof Map) {
                Map paramMap = (Map)params;
                Object province = paramMap.get("province");
                if (province instanceof Long) {
                    return this.getTableName((Long)province, baseTableName);
                }
                LOGGER.error("\u6839\u636eprovince\u8fdb\u884c\u5206\u8868\uff0cMap\u7c7b\u578b\u53c2\u6570\u4e2d\u5fc5\u987b\u6709\u952e\u540d\u4e3a[province]\u7684\u503c\uff0c\u800c\u4e14\u7c7b\u578b\u4e3aLong");
                return baseTableName;
            } else {
                LOGGER.error("[{}][{}]\u5df2\u5206\u8868\uff0c\u53c2\u6570\u652f\u6301[{}]\u6216[Long]\uff0c\u8bf7\u4fee\u6539", new Object[]{mapperId, baseTableName, IProvicneSharding.class});
            }
        }
        return baseTableName;
    }

    private String getTableName(Long province, String baseTableName) {
        return baseTableName + "_" + province;
    }
}

