/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.common.constant;

import com.bxm.newidea.component.tools.BitOperatorUtil;

public enum InfoCombineStateEnum {
    HEAD_IMG_COMPLETE(0),
    NICKNAME_COMPLETE(1),
    SEX_COMPLETE(2),
    BIRTHDAY_COMPLETE(3),
    HOMETOWN_COMPLETE(4),
    RELATION_SHIP_COMPLETE(5),
    JOB_COMPLETE(6),
    PERSONAL_PROFILE_COMPLETE(7),
    USER_TAG_COMPLETE(8),
    PHONE_COMPLETE(9),
    WECHAT_COMPLETE(10);

    public int index;

    public int getIndex() {
        return this.index;
    }

    private InfoCombineStateEnum(int index) {
        this.index = index;
    }

    public static InfoCombineStateEnum getByIndex(Integer index) {
        for (InfoCombineStateEnum authCodeEnum : InfoCombineStateEnum.values()) {
            if (index != authCodeEnum.index) continue;
            return authCodeEnum;
        }
        return null;
    }

    public static int getInfoCompleteStatus(Long infoCompleteStatus) {
        String s = Long.toBinaryString(infoCompleteStatus);
        int completeCount = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ('1' != c) continue;
            ++completeCount;
        }
        return completeCount;
    }

    public static int getInfoUnCompleteStatus(Long infoCompleteStatus) {
        int length = InfoCombineStateEnum.values().length;
        int completeStatus = InfoCombineStateEnum.getInfoCompleteStatus(infoCompleteStatus);
        return length - completeStatus;
    }

    public static int getCustomInfoCompleteStatus(Long infoCompleteStatus) {
        int infoCompleteValue = 0;
        if (BitOperatorUtil.getBitAsBoolean((long)infoCompleteStatus, (int)HEAD_IMG_COMPLETE.getIndex())) {
            infoCompleteValue += 2;
        }
        if (BitOperatorUtil.getBitAsBoolean((long)infoCompleteStatus, (int)NICKNAME_COMPLETE.getIndex())) {
            ++infoCompleteValue;
        }
        if (BitOperatorUtil.getBitAsBoolean((long)infoCompleteStatus, (int)SEX_COMPLETE.getIndex())) {
            ++infoCompleteValue;
        }
        if (BitOperatorUtil.getBitAsBoolean((long)infoCompleteStatus, (int)BIRTHDAY_COMPLETE.getIndex())) {
            ++infoCompleteValue;
        }
        if (BitOperatorUtil.getBitAsBoolean((long)infoCompleteStatus, (int)HOMETOWN_COMPLETE.getIndex())) {
            ++infoCompleteValue;
        }
        if (BitOperatorUtil.getBitAsBoolean((long)infoCompleteStatus, (int)RELATION_SHIP_COMPLETE.getIndex())) {
            ++infoCompleteValue;
        }
        if (BitOperatorUtil.getBitAsBoolean((long)infoCompleteStatus, (int)JOB_COMPLETE.getIndex())) {
            ++infoCompleteValue;
        }
        if (BitOperatorUtil.getBitAsBoolean((long)infoCompleteStatus, (int)PERSONAL_PROFILE_COMPLETE.getIndex())) {
            ++infoCompleteValue;
        }
        if (BitOperatorUtil.getBitAsBoolean((long)infoCompleteStatus, (int)USER_TAG_COMPLETE.getIndex())) {
            infoCompleteValue += 2;
        }
        if (BitOperatorUtil.getBitAsBoolean((long)infoCompleteStatus, (int)PHONE_COMPLETE.getIndex())) {
            infoCompleteValue += 2;
        }
        return infoCompleteValue;
    }

    public static int getInfoCompletePercent(Long infoCompleteStatus) {
        int infoCompleteNum = InfoCombineStateEnum.values().length;
        int infoCompleteStatusNum = InfoCombineStateEnum.getInfoCompleteStatus(infoCompleteStatus);
        return infoCompleteStatusNum * 100 / infoCompleteNum;
    }
}

