/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.common.sharding;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.vo.INewsIdSharding;
import com.google.code.shardbatis.strategy.ShardStrategy;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewsIdStrategy
implements ShardStrategy {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTargetTableName(String baseTableName, Object params, String mapperId) {
        if (params instanceof INewsIdSharding) {
            INewsIdSharding sharding = (INewsIdSharding)params;
            if (sharding.getNewsId() != null && sharding.getNewsId() != 0L) return this.getTableName(sharding.getNewsId(), baseTableName);
            this.LOGGER.error("\u6839\u636enewsId\u8fdb\u884c\u5206\u8868\uff0c\u5fc5\u987b\u6709\u503c\uff0c\u5b9e\u9645\u503c\u662f:[{}],mapperId:[{}]", (Object)JSONObject.toJSONString((Object)sharding), (Object)mapperId);
            return baseTableName;
        } else {
            if (params instanceof Long) {
                return this.getTableName((Long)params, baseTableName);
            }
            if (params instanceof Map) {
                Map paramMap = (Map)params;
                Object newsId = paramMap.get("newsId");
                if (newsId instanceof Long) {
                    return this.getTableName((Long)newsId, baseTableName);
                }
                this.LOGGER.error("\u6839\u636enewsId\u8fdb\u884c\u5206\u8868\uff0cMap\u7c7b\u578b\u53c2\u6570\u4e2d\u5fc5\u987b\u6709\u952e\u540d\u4e3a[newsId]\u7684\u503c\uff0c\u800c\u4e14\u7c7b\u578b\u4e3aLong");
                return baseTableName;
            } else {
                this.LOGGER.error("[{}][{}]\u5df2\u5206\u8868\uff0c\u53c2\u6570\u652f\u6301[{}]\u6216[Long]\uff0c\u8bf7\u4fee\u6539", new Object[]{mapperId, baseTableName, INewsIdSharding.class});
            }
        }
        return baseTableName;
    }

    private String getTableName(Long userId, String baseTableName) {
        return baseTableName + "_" + userId % 10L;
    }
}

