package com.bxm.localnews.common.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.util.StringUtils;

import java.lang.reflect.Field;

/**
 * 封装的分页参数 (▼ヘ▼#)
 * Created by youlianjie on 14-12-20.
 * @deprecated 不再推荐使用，可以使用{@link com.bxm.newidea.component.vo.PageParam}来进行分页
 */
@ApiModel(description = "分页参数")
@Deprecated
public class MPage extends PageModel {

    private final static Integer MAX_PAGE_SIZE = 60;

    private final static Integer DEFAULT_PAGE_SIZE = 20;

    @ApiModelProperty("当前页码")
    private Integer curPage = 0;

    @ApiModelProperty("每页数量,默认20")
    private Integer pageSize = 20;

    @ApiModelProperty("排序列")
    private String order;

    @ApiModelProperty("排序方式")
    private String orderTag;

    @ApiModelProperty("数据总数")
    private Integer itemTotal = 0;

    public MPage checkPage() {
        if (this.curPage == null || this.curPage <= 0) {
            this.curPage = 1;
        }
        if (this.pageSize == null || this.pageSize < 0 || this.pageSize > MAX_PAGE_SIZE) {
            this.pageSize = DEFAULT_PAGE_SIZE;
        }
        return this;
    }

    public MPage checkPage(Class c, String defaultOrder) {
        this.checkPage();
        boolean isFind = false;
        for (Field f : c.getDeclaredFields()) {
            if (f.getName().equals(this.order)) {
                isFind = true;
                break;
            }
        }
        if (!isFind) {
            this.order = defaultOrder;
        }
        if (StringUtils.isEmpty(this.getOrderTag())) {
            this.setOrderTag(null);
        }
        return this;
    }

    public Integer getStart() {
        return (this.curPage - 1) * this.pageSize;
    }

    public Integer getCurPage() {
        return this.curPage;
    }

    public void setCurPage(Integer curPage) {
        this.curPage = curPage;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getOrderTag() {
        return "ASC".equalsIgnoreCase(this.orderTag) ? "ASC" : "DESC";
    }

    public void setOrderTag(String orderTag) {
        this.orderTag = orderTag;
    }

    public Integer getItemTotal() {
        return this.itemTotal;
    }

    public MPage setItemTotal(Integer itemTotal) {
        this.itemTotal = itemTotal;
        return this;
    }

    public Integer getTotal() {
        if (this.itemTotal != null
                && this.getPageSize() != null) {
            int pageNum = this.itemTotal / this.getPageSize();
            int pageEnd = this.itemTotal % this.getPageSize();
            return pageNum + (pageEnd > 0 ? 1 : 0);
        } else {
            return null;
        }
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

}
