package com.bxm.localnews.common.sharding;

import com.bxm.localnews.common.vo.INewsIdSharding;
import com.bxm.localnews.common.vo.IProvicneSharding;
import com.bxm.localnews.common.vo.IUserIdSharding;
import com.google.code.shardbatis.strategy.ShardStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * 省份进行的分表策略
 */
public class ProvinceStrategy implements ShardStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(ProvinceStrategy.class);

    @Override
    public String getTargetTableName(String baseTableName, Object params, String mapperId) {
        if (params instanceof IProvicneSharding) {
            IProvicneSharding sharding = (IProvicneSharding) params;
            if (sharding.getProvince() == null || sharding.getProvince() == 0) {
                LOGGER.error("根据province进行分表，必须有值，实际值是0");
            } else {
                return getTableName(sharding.getProvince(), baseTableName);
            }
        } else if (params instanceof Long) {
            return getTableName((Long) params, baseTableName);
        } else if (params instanceof Map) {
            Map<String, Object> paramMap = (Map<String, Object>) params;
            Object province = paramMap.get("province");
            if (province instanceof Long) {
                return getTableName((Long) province, baseTableName);
            } else {
                LOGGER.error("根据province进行分表，Map类型参数中必须有键名为[province]的值，而且类型为Long");
            }
        } else {
            LOGGER.error("[{}][{}]已分表，参数支持[{}]或[Long]，请修改", mapperId, baseTableName, IProvicneSharding.class);
        }
        return baseTableName;
    }

    private String getTableName(Long province, String baseTableName) {
        return baseTableName + "_" + province;
    }

}