package com.bxm.localnews.common.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "短信发送响应")
public class SmsJson<T> extends Json {

    @ApiModelProperty(value = "短信发送倒计时")
    private int countDown;

    private SmsJson(Json<T> source) {
        super(source);
    }

    public static <T> SmsJson build(Json<T> source) {
        return new SmsJson<>(source);
    }

    public int getCountDown() {
        return this.countDown;
    }

    public SmsJson setCountDown(int countDown) {
        this.countDown = countDown;
        return this;
    }

}
