package com.bxm.localnews.common.sharding;

import com.bxm.localnews.common.vo.INewsIdSharding;
import com.bxm.localnews.common.vo.IUserIdSharding;
import com.google.code.shardbatis.strategy.ShardStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * 新闻ID进行的分表策略
 */
public class NewsIdStrategy implements ShardStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsIdStrategy.class);

    @Override
    public String getTargetTableName(String baseTableName, Object params, String mapperId) {
        if (params instanceof INewsIdSharding) {
            INewsIdSharding sharding = (INewsIdSharding) params;
            if (sharding.getNewsId() == null || sharding.getNewsId() == 0) {
                LOGGER.error("根据newsId进行分表，必须有值，实际值是0");
            } else {
                return getTableName(sharding.getNewsId(), baseTableName);
            }
        } else if (params instanceof Long) {
            return getTableName((Long) params, baseTableName);
        } else if (params instanceof Map) {
            Map<String, Object> paramMap = (Map<String, Object>) params;
            Object newsId = paramMap.get("newsId");
            if (newsId instanceof Long) {
                return getTableName((Long) newsId, baseTableName);
            } else {
                LOGGER.error("根据newsId进行分表，Map类型参数中必须有键名为[newsId]的值，而且类型为Long");
            }
        } else {
            LOGGER.error("[{}][{}]已分表，参数支持[{}]或[Long]，请修改", mapperId, baseTableName, INewsIdSharding.class);
        }
        return baseTableName;
    }

    private String getTableName(Long userId, String baseTableName) {
        return baseTableName + "_" + (userId % 10);
    }

}