package com.bxm.localnews.constant;

/**
 * 公共的国际化消息编码常量，具体显示内容参见apollo对应的i18N命名空间
 * @author liujia
 * @date 2019/11/26 22:13
 */
public class CommonI18NConstant {
    private CommonI18NConstant() {
    }

    /**
     * ==============================
     * 基础提示
     * ==============================
     */
    /**
     * 无显示消息时的提示文案（eg：无）
     */
    public static final String NONE = "common.none";

    /**
     * 请求不符合要求
     */
    public static final String BAD_REQUEST = "common.bad.request";

    /**
     * 请求参数错误
     */
    public static final String PARAM_ERROR = "common.param.error";

    /**
     * 服务器内部错误
     */
    public static final String SERVER_ERROR = "common.server.error";

    /**
     * 未授权提示
     */
    public static final String UNAUTHORIZED = "common.unauthorized";

    /**
     * 未登陆时的提示消息
     */
    public static final String UNLOGIN = "common.unlogin";

    /**
     * ==============================
     * 鉴权提示
     * ==============================
     */
    /**
     * 禁言提示
     */
    public static final String BANNED_PHASE = "auth.banned.phase";

    /**
     * 禁止评论
     */
    public static final String FORBID_COMMENT = "auth.forbid.comment";

    /**
     * 禁止发帖
     */
    public static final String FORBID_POST = "auth.forbid.post";

    /**
     * 禁止发小纸条
     */
    public static final String FORBID_NOTE = "auth.forbid.note";


}




















