package com.bxm.localnews.mq.common.constant;

/**
 * 用户事件定义枚举
 * 注意：因历史迁移原因，要注意与{@link PushMessageEnum}中定义的code进行区分
 * @author liujia
 */
public enum UserEventEnum {
    /**
     * 用户收入金额变更
     */
    USER_ACCOUNT_ENVET(90, "用户金额变动"),

    /**
     * 用户新增未读消息
     */
    USER_UN_READ_MSG(91, "用户未读消息数量"),

    /**
     * 小程序未读消息数量
     */
    APPLET_USER_UN_READ_MSG(92, "用户未读消息数量"),

    /**
     * 用户完成某些任务时通知
     */
    TASK_COMPLETE_EVENT(93, "任务完成提示"),

    /**
     * 用户解除私聊功能封禁
     */
    IM_UNBLOCK(94, "解除用户封禁"),

    /**
     * 用户权限信息发生变化时
     */
    AUTH_CHANGE(95, "权限变更"),

    /**
     * 未读的系统消息
     */
    UN_READ_SYSTEM_MSG(96, "用户未读系统消息数量"),

    /**
     * 新增粉丝
     */
    ADD_FOLLOW(200, "新增粉丝");

    public int type;

    public String title;

    UserEventEnum(int type, String title) {
        this.type = type;
        this.title = title;
    }
}
