package com.bxm.component.bus.event;

import org.springframework.cloud.bus.event.RemoteApplicationEvent;

/**
 * 远程传输事件
 *
 * @author liujia
 * @date 7/1/21 6:15 PM
 **/
public class RemoteEvent extends RemoteApplicationEvent {

    private Object transferObject;

    private boolean skipCurrentService = false;

    private RemoteEvent() {
        super();
    }

    public RemoteEvent(Object sourceObject, String originService, String destinationService) {
        super(sourceObject, originService, destinationService);
        this.transferObject = sourceObject;
    }

    public RemoteEvent(Object sourceObject, String originService) {
        super(sourceObject, originService);
        this.transferObject = sourceObject;
    }

    public Object getTransferObject() {
        return transferObject;
    }

    public boolean isSkipCurrentService() {
        return skipCurrentService;
    }

    public void setSkipCurrentService(boolean skipCurrentService) {
        this.skipCurrentService = skipCurrentService;
    }
}
