package com.bxm.component.mq.config;

import com.bxm.component.mq.enums.MessageTypeEnum;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 消息配置
 * @author lowi
 * @date 2021/8/18 10:06
 */
@ConfigurationProperties(prefix = "component.message")
@Data
@Component
public class MessageConfigurationProperties {

    /**
     * 实现消息客户端类型，默认为rabbit
     */
    private String messageType = MessageTypeEnum.RABBIT_MQ.name();
}
