package com.bxm.component.mq;

/**
 * 不同客户端消息消费对象
 * 必须指定泛型，用于声明监听的对象
 *
 * @author lowi
 * @date 2021/8/3 16:09
 */
public interface MessageConsumer<T> {

    /**
     * 消费
     *
     * @param value 消费的内容
     * @return 返回指定的类 huola-event里定义
     */
    T consumer(T value);

    /**
     * 唯一标识 huola-event项目定义
     * 实现此接口 需要指定好队列名称，配合监听生产者发送的队列，
     * 每个发送消息的和接收消息的指定一个唯一标识
     *
     * @return 唯一标识
     */
    String uniqueMark();
}
