/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.bus.listener;

import com.bxm.component.bus.event.RemoteEvent;
import com.bxm.component.bus.event.TransferMedia;
import com.bxm.component.bus.subscriber.IRemoteSubscriber;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.tools.ReflectionUtils;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class RemoteEventListener
implements ApplicationListener<RemoteEvent>,
ApplicationRunner,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(RemoteEventListener.class);
    private ApplicationContext applicationContext;
    private Map<String, IRemoteSubscriber> remoteSubscriberMap;
    private Map<String, Class<?>> subscriberClassMap;

    public void onApplicationEvent(RemoteEvent event) {
        Object source;
        if (log.isDebugEnabled()) {
            log.debug("\u63a5\u53d7\u5230\u8fdc\u7a0b\u4e8b\u4ef6\uff0c\u4e8b\u4ef6\u5bf9\u8c61\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)((Object)event)));
        }
        if (null == (source = event.getTransferObject())) {
            log.warn("\u63a5\u6536\u5230\u7684\u8fdc\u7a0b\u4e8b\u4ef6\uff0c\u6ca1\u6709\u4f20\u9012\u503c\uff0c\u4e0d\u4e88\u5904\u7406");
            return;
        }
        if (source instanceof LinkedHashMap) {
            LinkedHashMap dataMap = (LinkedHashMap)source;
            String transferClassName = (String)dataMap.get("className");
            String jsonValue = (String)dataMap.get("jsonValue");
            this.consume(transferClassName, jsonValue);
        } else if (source instanceof TransferMedia) {
            if (event.isSkipCurrentService()) {
                if (log.isDebugEnabled()) {
                    log.debug("\u5f53\u524d\u5b9e\u4f8b\u4e0d\u6267\u884c\uff0c\u8df3\u8fc7\uff1a{}", (Object)event.getOriginService());
                }
                return;
            }
            TransferMedia media = (TransferMedia)source;
            this.consume(media.getClassName(), media.getJsonValue());
        } else {
            log.info("\u63a5\u6536\u7684\u5bf9\u8c61\u7c7b\u578b\u65e0\u6cd5\u5904\u7406\uff0c\u7c7b\u578b\u4e3a\uff1a{}", (Object)source.getClass().getName());
        }
    }

    private void consume(String className, String jsonValue) {
        IRemoteSubscriber subscriber = this.remoteSubscriberMap.get(className);
        if (null == subscriber) {
            log.info("[{}]\u6ca1\u6709\u5bf9\u5e94\u7684\u8ba2\u9605\u8005\uff0c\u4e0d\u8fdb\u884c\u5904\u7406", (Object)className);
            return;
        }
        subscriber.consume(JSON.parseObject((String)jsonValue, this.subscriberClassMap.get(className)));
    }

    public void run(ApplicationArguments args) {
        Map subscriberMap = this.applicationContext.getBeansOfType(IRemoteSubscriber.class);
        this.remoteSubscriberMap = Maps.newHashMap();
        this.subscriberClassMap = Maps.newHashMap();
        for (IRemoteSubscriber subscriber : subscriberMap.values()) {
            Class subscriberValueClass = ReflectionUtils.getFirstGenericType(subscriber.getClass());
            if (null == subscriberValueClass) {
                log.error("\u58f0\u660e\u7684[{}]\u6ca1\u6709\u6307\u5b9a\u6cdb\u578b\uff0c\u65e0\u6cd5\u5339\u914d\u8ba2\u9605\u6570\u636e", (Object)subscriber.getClass().getSimpleName());
                continue;
            }
            this.remoteSubscriberMap.put(subscriberValueClass.getName(), subscriber);
            this.subscriberClassMap.put(subscriberValueClass.getName(), subscriberValueClass);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public RemoteEventListener(ApplicationContext applicationContext, Map<String, IRemoteSubscriber> remoteSubscriberMap, Map<String, Class<?>> subscriberClassMap) {
        this.applicationContext = applicationContext;
        this.remoteSubscriberMap = remoteSubscriberMap;
        this.subscriberClassMap = subscriberClassMap;
    }
}

