/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.mq.message.send.impl.strategy;

import com.bxm.component.mq.config.RabbitConfigurationProperties;
import com.bxm.component.mq.enums.MessageTypeEnum;
import com.bxm.component.mq.message.send.impl.strategy.MessageStrategy;
import com.bxm.newidea.component.JSON;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RabbitMessageSendStrategy
extends MessageStrategy {
    private static final Logger log = LoggerFactory.getLogger(RabbitMessageSendStrategy.class);
    @Autowired
    private ConnectionFactory connectionFactory;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private RabbitConfigurationProperties configurationProperties;

    public void sendMessage(String uniqueMark, Object message) {
        String routing = uniqueMark + "-routing";
        String exchange = uniqueMark + "-exchange";
        try {
            this.buildMessageSender(uniqueMark, routing, exchange, message);
        }
        catch (IOException e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c{}", (Object)JSON.toJSONString((Object)message), (Object)e);
        }
    }

    private void buildMessageSender(String queue, String routing, String exchange, Object message) throws IOException {
        Connection connection = this.connectionFactory.createConnection();
        this.buildQueue(exchange, routing, queue, connection);
        this.rabbitTemplate.setConnectionFactory(this.connectionFactory);
        this.rabbitTemplate.setMandatory(true);
        this.rabbitTemplate.setExchange(exchange);
        this.rabbitTemplate.setRoutingKey(routing);
        this.rabbitTemplate.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
        this.rabbitTemplate.convertAndSend(message);
    }

    private void buildQueue(String exchange, String routingKey, String queue, Connection connection) throws IOException {
        Channel channel = connection.createChannel(false);
        channel.exchangeDeclare(exchange, this.configurationProperties.getType(), this.configurationProperties.getDurable().booleanValue(), this.configurationProperties.getAutoDelete().booleanValue(), this.configurationProperties.getArguments());
        channel.queueDeclare(queue, this.configurationProperties.getDurable().booleanValue(), this.configurationProperties.getExclusive().booleanValue(), this.configurationProperties.getAutoDelete().booleanValue(), this.configurationProperties.getArguments());
        channel.queueBind(queue, exchange, routingKey);
        try {
            channel.close();
        }
        catch (TimeoutException e) {
            log.info("\u5173\u95ed\u901a\u9053\u8d85\u65f6 ", (Throwable)e);
        }
    }

    @Override
    public String getType() {
        return MessageTypeEnum.RABBIT_MQ.name();
    }
}

