/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.bus.config;

import com.bxm.component.bus.event.IEventValue;
import com.bxm.component.bus.event.RemoteEvent;
import com.bxm.component.bus.event.TransferMedia;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.tools.SpringContextHolder;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.context.ApplicationEvent;

public final class ComponentEventBus {
    static BusProperties busProperties;

    public static <T> void publishInnerEvent(T event) {
        SpringContextHolder.getApplicationContext().publishEvent(event);
    }

    public static <T extends IEventValue> void publishRemoteEvent(T eventValue) {
        ComponentEventBus.publishRemote(eventValue, null, false);
    }

    public static <T extends IEventValue> void publishRemoteEventSkipSelf(T eventValue) {
        ComponentEventBus.publishRemote(eventValue, null, true);
    }

    public static <T extends IEventValue> void publishRemoteEvent(T eventValue, String destinationService) {
        ComponentEventBus.publishRemote(eventValue, destinationService, true);
    }

    private static <T extends IEventValue> void publishRemote(T eventValue, String destinationService, boolean skipSelf) {
        TransferMedia transferMedia = new TransferMedia();
        transferMedia.setClassName(eventValue.getClass().getName());
        transferMedia.setJsonValue(JSON.toJSONString(eventValue));
        RemoteEvent event = new RemoteEvent(transferMedia, busProperties.getId(), destinationService);
        event.setSkipCurrentService(skipSelf);
        SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)event);
    }

    private ComponentEventBus() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

