package com.bxm.component.bus.config;

import com.bxm.component.bus.event.RemoteEvent;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.cloud.bus.BusAutoConfiguration;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.cloud.bus.jackson.RemoteApplicationEventScan;
import org.springframework.context.annotation.Configuration;

/**
 * 消息总线配置
 *
 * @author liujia
 * @date 7/1/21 5:12 PM
 **/
@Configuration
@RemoteApplicationEventScan(basePackageClasses = {RemoteEvent.class})
@AutoConfigureAfter(BusAutoConfiguration.class)
public class ComponentBusConfiguration {

    public ComponentBusConfiguration(BusProperties busProperties) {
        ComponentEventBus.busProperties = busProperties;
    }
}
