package com.bxm.component.mq.listener.rabbit;

import com.bxm.component.mq.conditionals.MessageConditionalOnProperty;
import com.bxm.component.mq.consumer.MessageConsumer;
import com.bxm.component.mq.enums.MessageTypeEnum;
import com.bxm.newidea.component.JSON;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;

/**
 * 具体的消费实现类
 *
 * @author lowi
 * @date 2021/8/3 17:11
 */
@Slf4j
@MessageConditionalOnProperty(type = MessageTypeEnum.RABBIT_MQ)
public class DefaultRabbitConsumer<T> extends DefaultConsumer {

    private static MessageConsumer messageConsumer;

    private static Class<?> className;

    public DefaultRabbitConsumer(Channel channel, MessageConsumer subscriber, Class<?> className) {
        super(channel);
        messageConsumer = subscriber;
        this.className = className;
    }

    @Override
    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        messageConsumer.consumer(JSON.parseObject(new String(body), className));
    }
}
