package com.bxm.component.mq.send.strategy;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;

/**
 * @author lowi
 * @date 2021/8/18 10:10
 */
@Component
public class MessageContextProcess {

    private HashMap<String, MessageStrategy> strategyHashMap;


    public MessageContextProcess(List<MessageStrategy> strategies) {
        strategyHashMap = new HashMap<>((int) (strategies.size() / .75f) + 1);
        strategies.forEach(entity -> strategyHashMap.put(entity.getType(), entity));
    }


    public void sendMessage(String type, String uniqueMark, Object message) {
        strategyHashMap.get(type).sendMessage(uniqueMark, message);
    }

}
