package com.bxm.component.mq.send.strategy;

import com.bxm.component.mq.config.MessageConfigurationProperties;
import com.bxm.component.mq.send.MessageSender;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author lowi
 * @date 2021/8/18 10:22
 */
@Service
@Slf4j
public class MessageSenderImpl implements MessageSender {

    @Autowired
    private MessageConfigurationProperties configurationProperties;

    @Autowired
    private MessageContextProcess messageContextProcess;

    @Override
    public void send(String uniqueMark, Object message) {
        messageContextProcess.sendMessage(configurationProperties.getMessageType(), uniqueMark, message);
    }
}
