package com.bxm.component.mq.send.strategy;

import org.springframework.stereotype.Component;

/**
 * @author lowi
 * @date 2021/8/18 10:14
 */
@Component
public abstract class MessageStrategy {

    /**
     * 发送消息
     *
     * @param uniqueMark 唯一标识
     * @param message    消息体
     */
    public abstract void sendMessage(String uniqueMark, Object message);

    /**
     * 获取发消息的类型
     *
     * @return 发送消息客户端的类型
     */
    public abstract String getType();
}
