package com.bxm.component.mq.send.strategy;

import com.bxm.component.mq.enums.MessageTypeEnum;
import com.bxm.newidea.component.JSON;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.concurrent.TimeoutException;

/**
 * @author lowi
 * @date 2021/8/3 16:09
 */
@Slf4j
@Component
public class RabbitMessageSendStrategy extends MessageStrategy {

    @Autowired
    private ConnectionFactory connectionFactory;

    @Override
    public void sendMessage(String uniqueMark, Object message) {
        String routing = uniqueMark + "-routing";
        String exchange = uniqueMark + "-exchange";
        try {
            buildMessageSender(uniqueMark, routing, exchange, message);
        } catch (IOException e) {
            log.error("发送消息失败，{}", JSON.toJSONString(message), e);
        }
    }

    private void buildMessageSender(String queue, String routing, String exchange, Object message) throws IOException {
        final Connection connection = connectionFactory.createConnection();

        buildQueue(exchange, routing, queue, connection);
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        rabbitTemplate.setMandatory(true);
        rabbitTemplate.setExchange(exchange);
        rabbitTemplate.setRoutingKey(routing);
        rabbitTemplate.setMessageConverter(new Jackson2JsonMessageConverter());
        rabbitTemplate.convertAndSend(message);
    }

    private void buildQueue(String exchange, String routingKey,
                            final String queue, Connection connection) throws IOException {
        Channel channel = connection.createChannel(false);
        channel.exchangeDeclare(exchange, "direct", true, false, null);
        channel.queueDeclare(queue, true, false, false, null);
        channel.queueBind(queue, exchange, routingKey);
        try {
            channel.close();
        } catch (TimeoutException e) {
            log.info("close channel time out ", e);
        }
    }

    @Override
    public String getType() {
        return MessageTypeEnum.RABBIT_MQ.name();
    }
}
