/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.mq.message.listener.rabbit;

import com.bxm.component.mq.MessageConsumer;
import com.bxm.component.mq.conditionals.MessageConditionalOnProperty;
import com.bxm.component.mq.enums.MessageTypeEnum;
import com.bxm.newidea.component.JSON;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MessageConditionalOnProperty(type=MessageTypeEnum.RABBIT_MQ)
public class ConcreteRabbitConsumer<T>
extends DefaultConsumer {
    private static final Logger log = LoggerFactory.getLogger(ConcreteRabbitConsumer.class);
    private static Map<String, MessageConsumer> messageConsumerMaps = new HashMap<String, MessageConsumer>();
    private static Map<String, Class<?>> classNameMaps = new HashMap();

    public ConcreteRabbitConsumer(Channel channel, MessageConsumer subscriber, Class<?> className, String exchange) {
        super(channel);
        messageConsumerMaps.put(exchange, subscriber);
        classNameMaps.put(exchange, className);
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        MessageConsumer messageConsumer = messageConsumerMaps.get(envelope.getExchange());
        Class<?> className = classNameMaps.get(envelope.getExchange());
        messageConsumer.consumer(JSON.parseObject((String)new String(body), className));
    }
}

