package com.bxm.component.bus.config;

import com.bxm.component.bus.guava.EventBus;
import lombok.experimental.UtilityClass;

/**
 * 消息总线调用入口
 *
 * @author liujia
 * @date 7/1/21 5:24 PM
 **/
@UtilityClass
public class ComponentEventBus {

    EventBus asyncEventBus;

    /**
     * 发布一个异步事件
     *
     * @param event 事件源，可以是任何对象
     */
    public <T> void publishEvent(T event) {
        asyncEventBus.post(event);
    }

    /**
     * 获取异步的事件发布总线
     *
     * @return 事件总线
     */
    public EventBus eventBus() {
        return asyncEventBus;
    }
}
