/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.bus.config;

import com.bxm.component.bus.annotations.EventBusSubscriber;
import com.bxm.component.bus.config.ComponentEventBus;
import com.bxm.component.bus.event.IEventBusSubscriber;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class EventBusSubscriberBeanPostProcessor
implements BeanPostProcessor,
Ordered,
ApplicationRunner {
    private List<Object> subscriberList = Lists.newArrayList();

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof IEventBusSubscriber) {
            this.subscriberList.add(bean);
        } else {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = ReflectionUtils.getAllDeclaredMethods(bean.getClass())) {
                EventBusSubscriber annotation = (EventBusSubscriber)AnnotationUtils.findAnnotation((Method)declaredMethod, EventBusSubscriber.class);
                if (annotation == null) continue;
                this.subscriberList.add(bean);
                break;
            }
        }
        return bean;
    }

    public void run(ApplicationArguments args) throws Exception {
        for (Object subscriber : this.subscriberList) {
            ComponentEventBus.eventBus().register(subscriber);
        }
        this.subscriberList = null;
    }
}

