package com.bxm.newidea.component.controller;

import com.bxm.newidea.component.binder.DateEditor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;


/**
 * controller 基类
 * 预留，后续用于处理公共内容
 * @author liujia 2018/3/30 17:20
 */
public class BaseController {

    protected static final String RESULT_KEY = "result";

    protected Logger logger = LogManager.getLogger(this.getClass());

    /**
     * 属性值绑定转换编辑器
     * @param binder 绑定集合
     */
    @InitBinder
    public void initBinding(WebDataBinder binder) {
        //string类型转换为空时，转换为null而不是空字符串
        binder.registerCustomEditor(String.class, new StringTrimmerEditor(true));
        //使用自定义的日期转换
        binder.registerCustomEditor(Date.class, new DateEditor());
    }

    protected void write(HttpServletResponse response, String content) {
        try {
            response.getWriter().write(content);
            response.getWriter().flush();
        } catch (IOException e) {
            this.logger.error(e);
        }
    }
}
