package com.bxm.newidea.component.tools;

import org.apache.commons.lang3.ArrayUtils;

import java.util.Map;
import java.util.regex.Pattern;

/**
 * 字符串操作工具类
 * @author liujia
 */
public class StringUtils extends org.apache.commons.lang3.StringUtils {

    public static final char[] DIGITS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();

    public static final char[] DIGITS_NOCASE = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    private final static Pattern CRLF_PATTERN = Pattern.compile("\\r|\\n|\\r\\n");

    private StringUtils() {
    }

    /**
     * 将一个byte数组转换成62进制的字符串。
     */
    public static String bytesToString(byte[] bytes) {
        return bytesToString(bytes, false);
    }

    /**
     * 将一个byte数组转换成62进制的字符串。
     * @param bytes  源数组
     * @param noCase 是否采用小写字母
     */
    public static String bytesToString(byte[] bytes, boolean noCase) {
        char[] digits = noCase ? DIGITS_NOCASE : DIGITS;
        int digitsLength = digits.length;

        if (ArrayUtils.isEmpty(bytes)) {
            return String.valueOf(digits[0]);
        }

        StringBuilder strValue = new StringBuilder();
        int value = 0;
        int limit = Integer.MAX_VALUE >>> 8;
        int i = 0;

        do {
            while (i < bytes.length && value < limit) {
                value = (value << 8) + (0xFF & bytes[i++]);
            }

            while (value >= digitsLength) {
                strValue.append(digits[value % digitsLength]);
                value = value / digitsLength;
            }
        } while (i < bytes.length);

        if (value != 0 || strValue.length() == 0) {
            strValue.append(digits[value]);
        }

        return strValue.toString();
    }

    /**
     * 将一个长整形转换成62进制的字符串。
     */
    public static String longToString(long longValue) {
        return longToString(longValue, false);
    }

    /**
     * 将一个长整形转换成62进制的字符串。
     */
    public static String longToString(long longValue, boolean noCase) {
        char[] digits = noCase ? DIGITS_NOCASE : DIGITS;
        int digitsLength = digits.length;

        if (longValue == 0) {
            return String.valueOf(digits[0]);
        }

        if (longValue < 0) {
            longValue = -longValue;
        }

        StringBuilder strValue = new StringBuilder();

        while (longValue != 0) {
            int digit = (int) (longValue % digitsLength);
            longValue = longValue / digitsLength;

            strValue.append(digits[digit]);
        }

        return strValue.toString();
    }

    /**
     * 字符串拼接
     * 如果提供的字符串为null则忽略
     * @param s1 初步数据
     * @param s2 需要拼接的数据
     * @return 返回结果
     */
    public static String stringConcat(String s1, String s2) {
        String result = "";
        if (null != s1) {
            result += s1;
        }
        if (null != s2) {
            result += s2;
        }
        return result;
    }

    public static boolean notEquals(final CharSequence cs1, final CharSequence cs2) {
        return !equals(cs1, cs2);
    }

    public static boolean notEqualsIgnoreCase(final CharSequence cs1, final CharSequence cs2) {
        return !equalsIgnoreCase(cs1, cs2);
    }

    /**
     * 将int转换为62进制的显示形式
     * @param num 转换前的数字
     * @return 62进制表示字符串
     */
    public static String codes62(int num) {
        int num1 = (num / (62 * 62)) % 62;
        int num2 = (num / 62) % 62;
        int num3 = num % 62;

        String numOne = String.valueOf(DIGITS).charAt(num1) + "";
        String numTwo = String.valueOf(DIGITS).charAt(num2) + "";
        String numThree = String.valueOf(DIGITS).charAt(num3) + "";
        return numOne + numTwo + numThree;
    }

    /**
     * 字符模板占位符替换
     * @param template 模板内容，其中包含{x}表示的占位符
     * @param param    根据占位符进行内容替换
     * @return 模板替换后的结果
     */
    public static String convertMessage(String template, Map<String, String> param) {
        if (template != null && param != null && !param.isEmpty()) {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                template = template.replace("{" + entry.getKey() + "}", entry.getValue());
            }
        }
        return template;
    }

    /**
     * 隐藏手机号中间四位
     * @param mobile
     * @return
     */
    public static String hideMobile(String mobile) {
        StringBuilder sb = new StringBuilder();
        if (isNotEmpty(mobile) && mobile.length() > 6) {
            for (int i = 0; i < mobile.length(); i++) {
                char c = mobile.charAt(i);
                if (i >= 3 && i <= 6) {
                    sb.append('*');
                } else {
                    sb.append(c);
                }
            }

        }
        return sb.toString();
    }
}
