package com.bxm.newidea.component.tools;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/**
 * @author xiangui
 * 描述: 去除List中的相同对象
 * 时间：2018/7/5 11:19
 */
public class ObjectRemoveSame {

    /**
     * 根据传递的（字段/属性/领域 名称）去重
     *
     * @param objectList 传递的集合
     * @param codeId 字段/属性/领域 名称
     * @return 返回新的集合
     */
    public static <T> List<T> removeDupliByField(List<T> objectList, String codeId) {
        Set<T> obSet = new TreeSet<>((o1, o2) -> getValueByKey(o1,codeId).toString().compareTo(String.valueOf(getValueByKey(o2,codeId))));
        obSet.addAll(objectList);
        return new ArrayList<T>(obSet);
    }

    /**
     * 返回的一个值
     * @param obj 对象
     * @param key 属性
     * @return 返回结果值
     */
    private static Object getValueByKey(Object obj, String key) {
        // 得到类对象
        Class userCla = (Class) obj.getClass();
        /* 得到类中的所有属性集合 */
        Field[] fs = userCla.getDeclaredFields();
        for (Field f : fs) {
            f.setAccessible(true); // 设置些属性是可以访问的
            try {
                if (f.getName().endsWith(key)) {
                    return f.get(obj);
                }
            } catch (IllegalArgumentException | IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        // 没有查到时返回空字符串
        return "";
    }

}
