/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.tools;

import java.util.Arrays;
import java.util.List;

public class BitOperatorUtil {
    public static byte integerTo1Byte(int value) {
        return (byte)(value & 0xFF);
    }

    public static byte[] integerTo1Bytes(int value) {
        byte[] result = new byte[]{(byte)(value & 0xFF)};
        return result;
    }

    public static byte[] integerTo2Bytes(int value) {
        byte[] result = new byte[]{(byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return result;
    }

    public static byte[] integerTo3Bytes(int value) {
        byte[] result = new byte[]{(byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return result;
    }

    public static byte[] integerTo4Bytes(int value) {
        byte[] result = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return result;
    }

    public static int byteToInteger(byte[] value) {
        int result = value.length == 1 ? BitOperatorUtil.oneByteToInteger(value[0]) : (value.length == 2 ? BitOperatorUtil.twoBytesToInteger(value) : (value.length == 3 ? BitOperatorUtil.threeBytesToInteger(value) : (value.length == 4 ? BitOperatorUtil.fourBytesToInteger(value) : BitOperatorUtil.fourBytesToInteger(value))));
        return result;
    }

    public static byte[] short2Byte(short number) {
        int temp = number;
        byte[] b = new byte[2];
        for (int i = 0; i < b.length; ++i) {
            b[i] = new Integer(temp & 0xFF).byteValue();
            temp >>= 8;
        }
        return b;
    }

    public static int oneByteToInteger(byte value) {
        return value & 0xFF;
    }

    public static int twoBytesToInteger(byte[] value) {
        int temp0 = value[0] & 0xFF;
        int temp1 = value[1] & 0xFF;
        return (temp0 << 8) + temp1;
    }

    public static int threeBytesToInteger(byte[] value) {
        int temp0 = value[0] & 0xFF;
        int temp1 = value[1] & 0xFF;
        int temp2 = value[2] & 0xFF;
        return (temp0 << 16) + (temp1 << 8) + temp2;
    }

    public static int fourBytesToInteger(byte[] value) {
        int temp0 = value[0] & 0xFF;
        int temp1 = value[1] & 0xFF;
        int temp2 = value[2] & 0xFF;
        int temp3 = value[3] & 0xFF;
        return (temp0 << 24) + (temp1 << 16) + (temp2 << 8) + temp3;
    }

    public static long fourBytesToLong(byte[] value) throws Exception {
        int temp0 = value[0] & 0xFF;
        int temp1 = value[1] & 0xFF;
        int temp2 = value[2] & 0xFF;
        int temp3 = value[3] & 0xFF;
        return ((long)temp0 << 24) + (long)(temp1 << 16) + (long)(temp2 << 8) + (long)temp3;
    }

    public static long bytes2Long(byte[] value) {
        long result = 0L;
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            int temp = (len - 1 - i) * 8;
            if (temp == 0) {
                result += (long)(value[i] & 0xFF);
                continue;
            }
            result += (long)((value[i] & 0xFF) << temp);
        }
        return result;
    }

    public static byte[] longToBytes(long value) {
        return BitOperatorUtil.longToBytes(value, 8);
    }

    public static byte[] longToBytes(long value, int len) {
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            int temp = (len - 1 - i) * 8;
            if (temp == 0) {
                int n = i;
                result[n] = (byte)((long)result[n] + (value & 0xFFL));
                continue;
            }
            int n = i;
            result[n] = (byte)((long)result[n] + (value >>> temp & 0xFFL));
        }
        return result;
    }

    public static byte[] generateTransactionID() throws Exception {
        byte[] id = new byte[16];
        System.arraycopy(BitOperatorUtil.integerTo2Bytes((int)(Math.random() * 65536.0)), 0, id, 0, 2);
        System.arraycopy(BitOperatorUtil.integerTo2Bytes((int)(Math.random() * 65536.0)), 0, id, 2, 2);
        System.arraycopy(BitOperatorUtil.integerTo2Bytes((int)(Math.random() * 65536.0)), 0, id, 4, 2);
        System.arraycopy(BitOperatorUtil.integerTo2Bytes((int)(Math.random() * 65536.0)), 0, id, 6, 2);
        System.arraycopy(BitOperatorUtil.integerTo2Bytes((int)(Math.random() * 65536.0)), 0, id, 8, 2);
        System.arraycopy(BitOperatorUtil.integerTo2Bytes((int)(Math.random() * 65536.0)), 0, id, 10, 2);
        System.arraycopy(BitOperatorUtil.integerTo2Bytes((int)(Math.random() * 65536.0)), 0, id, 12, 2);
        System.arraycopy(BitOperatorUtil.integerTo2Bytes((int)(Math.random() * 65536.0)), 0, id, 14, 2);
        return id;
    }

    public static int[] getIntIPValue(String ip) throws Exception {
        String[] sip = ip.split("[.]");
        int[] intIP = new int[]{Integer.parseInt(sip[0]), Integer.parseInt(sip[1]), Integer.parseInt(sip[2]), Integer.parseInt(sip[3])};
        return intIP;
    }

    public static String getStringIPValue(byte[] address) throws Exception {
        int first = BitOperatorUtil.oneByteToInteger(address[0]);
        int second = BitOperatorUtil.oneByteToInteger(address[1]);
        int third = BitOperatorUtil.oneByteToInteger(address[2]);
        int fourth = BitOperatorUtil.oneByteToInteger(address[3]);
        return first + "." + second + "." + third + "." + fourth;
    }

    public static byte[] concatAll(byte[] first, byte[] ... rest) {
        int totalLength = first.length;
        for (byte[] array : rest) {
            if (array == null) continue;
            totalLength += array.length;
        }
        byte[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (byte[] array : rest) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static byte[] concatAll(List<byte[]> rest) {
        int totalLength = 0;
        for (byte[] array : rest) {
            if (array == null) continue;
            totalLength += array.length;
        }
        byte[] result = new byte[totalLength];
        int offset = 0;
        for (byte[] array : rest) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static float byte2Float(byte[] bs) {
        return Float.intBitsToFloat(((bs[3] & 0xFF) << 24) + ((bs[2] & 0xFF) << 16) + ((bs[1] & 0xFF) << 8) + (bs[0] & 0xFF));
    }

    public static float byteBE2Float(byte[] bytes) {
        int l = bytes[0];
        l &= 0xFF;
        l = (int)((long)l | (long)bytes[1] << 8);
        l &= 0xFFFF;
        l = (int)((long)l | (long)bytes[2] << 16);
        l &= 0xFFFFFF;
        l = (int)((long)l | (long)bytes[3] << 24);
        return Float.intBitsToFloat(l);
    }

    public static int getCheckSum4JT808(byte[] bs, int start, int end) {
        if (start < 0 || end > bs.length) {
            throw new ArrayIndexOutOfBoundsException("getCheckSum4JT808 error : index out of bounds(start=" + start + ",end=" + end + ",bytes length=" + bs.length + ")");
        }
        int cs = 0;
        for (int i = start; i < end; ++i) {
            cs ^= bs[i];
        }
        return cs;
    }

    public static int getBitRange(int number, int start, int end) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("min index is 0,but start = " + start);
        }
        if (end >= 32) {
            throw new IndexOutOfBoundsException("max index is 31,but end = " + end);
        }
        return number << 32 - (end + 1) >>> 32 - (end - start + 1);
    }

    public static int getBitAt(int number, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("min index is 0,but " + index);
        }
        if (index >= 32) {
            throw new IndexOutOfBoundsException("max index is 31,but " + index);
        }
        return (1 << index & number) >> index;
    }

    public static int getBitAtS(int number, int index) {
        String s = Integer.toBinaryString(number);
        return Integer.parseInt(s.charAt(index) + "");
    }

    @Deprecated
    public static int getBitRangeS(int number, int start, int end) {
        String s = Integer.toBinaryString(number);
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() < 32) {
            sb.insert(0, "0");
        }
        String tmp = sb.reverse().substring(start, end + 1);
        sb = new StringBuilder(tmp);
        return Integer.parseInt(sb.reverse().toString(), 2);
    }
}

