/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.tools;

import com.bxm.newidea.component.tools.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;

public class UUIDUtils {
    private static boolean noCase = true;
    private static String instanceId;
    private static AtomicInteger counter;

    private UUIDUtils() {
    }

    private static byte[] getLocalHostAddress() {
        byte[] addr;
        Method getHardwareAddress;
        try {
            getHardwareAddress = NetworkInterface.class.getMethod("getHardwareAddress", new Class[0]);
        }
        catch (Exception e) {
            getHardwareAddress = null;
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            addr = getHardwareAddress != null ? (byte[])getHardwareAddress.invoke((Object)NetworkInterface.getByInetAddress(localHost), new Object[0]) : localHost.getAddress();
        }
        catch (Exception e) {
            addr = null;
        }
        if (addr == null) {
            addr = new byte[]{127, 0, 0, 1};
        }
        return addr;
    }

    private static byte[] getRandomizedTime() {
        long jvmId = System.currentTimeMillis();
        long random = new SecureRandom().nextLong();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeLong(jvmId);
            dos.writeLong(random);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public static String nextID() {
        return instanceId + StringUtils.longToString(System.currentTimeMillis(), noCase) + StringUtils.longToString(counter.getAndIncrement(), noCase);
    }

    public static String nextHexId() {
        String uuid = UUIDUtils.nextID();
        return Integer.toHexString(uuid.hashCode());
    }

    static {
        byte[] machineId = UUIDUtils.getLocalHostAddress();
        byte[] jvmId = UUIDUtils.getRandomizedTime();
        instanceId = StringUtils.bytesToString(machineId, noCase) + StringUtils.bytesToString(jvmId, noCase);
        counter = new AtomicInteger();
    }
}

