package com.bxm.newidea.component.tools;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;

/**
 * 图形验证码生成
 *
 * @author zhangyuan 2018/4/9 14:55
 */
public class CaptchaUtil {

    /**
     * 去掉了1,0,i,o几个容易混淆的字符
     */
    private static final String VERIFY_CODES = "23456789abcdefghigklmnpqrstuvwxyz";

    private static Random random = new Random();

    /**
     * 方法的描述： 随机生成随字符串
     *
     * @param n 生成字符的个数
     * @return String 生成的字符串
     */
    public static String getRundomStr(int n) {
        StringBuilder sb = new StringBuilder();
        String[] strs = VERIFY_CODES.split("");
        // 循环控制字符个数
        for (int i = 0; i < n; i++) {
            String temp;
            int a = random.nextInt(strs.length);
            if (a < 24) {
                int b = random.nextInt(100);
                if (b % 2 == 0) {
                    temp = strs[a].toUpperCase();
                    sb.append(temp);
                } else {
                    sb.append(strs[a]);
                }
            } else {
                sb.append(strs[a]);
            }
        }
        return sb.toString();
    }

    /**
     * 验证码生成逻辑
     */
    public static void createImage(int w, int h, String str, OutputStream out) throws IOException {
        int verifySize = str.length();
        BufferedImage image = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
        Random rand = new Random();
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

        Color[] colors = new Color[5];
        Color[] colorSpaces = new Color[]{Color.WHITE, Color.CYAN,
                Color.GRAY, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE,
                Color.PINK, Color.YELLOW};

        float[] fractions = new float[colors.length];
        for (int i = 0; i < colors.length; i++) {
            colors[i] = colorSpaces[rand.nextInt(colorSpaces.length)];
            fractions[i] = rand.nextFloat();
        }
        // 设置背景色
        g2.setColor(new Color(255, 255, 255));
        g2.fillRect(0, 0, w, h);
        //绘制干扰线
        for (int i = 0; i < 4; i++) {
            g2.setColor(getRundomRgb(40, 180));
            g2.drawLine(randomNum(0, w), randomNum(0, h), randomNum(0, w), randomNum(0, h));
        }
        //绘制字符串
        int fontSize = h - 2;
        Font font = new Font("Algerian", Font.ITALIC, fontSize);
        char[] chars = str.toCharArray();
        for (int i = 0; i < verifySize; i++) {
            g2.setColor(getRundomRgb(40, 180));
            g2.setFont(font);
            AffineTransform affine = new AffineTransform();
            affine.setToRotation(Math.PI / 4 * rand.nextDouble() * (rand.nextBoolean() ? 1 : -1), (w / verifySize) * i + fontSize / 2, h / 2);
            g2.setTransform(affine);
            g2.drawChars(chars, i, 1, ((w - 10) / verifySize) * i + 5, h / 2 + fontSize / 2 - 10);
        }
        g2.dispose();
        ImageIO.write(image, "png", out);
    }

    /**
     * 随机生成RGB颜色
     */
    private static Color getRundomRgb(int pr, int pg) {
        if (pr > 255) {
            pr = 255;
        }
        if (pg > 255) {
            pg = 255;
        }
        int r = pr + random.nextInt(pg - pr);
        int g = pr + random.nextInt(pg - pr);
        int b = pr + random.nextInt(pg - pr);
        return new Color(r, g, b);
    }

    /**
     * 生成随机数
     */
    private static int randomNum(int min, int max) {
        return (int) Math.floor(Math.random() * (max - min) + min);
    }

}
