package com.bxm.newidea.component.converter;

/**
 * 适用于map struct的类型转换器
 *
 * @author liujia
 * @date 9/27/21 1:46 PM
 **/
public class MapstructTypeHandler {

    public boolean intToBoolean(int value) {
        return 0 != value;
    }

    public boolean intToBoolean(Integer value) {
        return null != value && 0 != value;
    }

    public boolean byteToBoolean(byte value) {
        return 0 != value;
    }

    public boolean byteToBoolean(Byte value) {
        return null != value && 0 != value;
    }

    public boolean stringToBoolean(String value) {
        return Boolean.valueOf(value);
    }

    public int booleanToInt(Boolean value) {
        return (null != value && value) ? 1 : 0;
    }

    public int booleanToInt(boolean value) {
        return value ? 1 : 0;
    }

    public byte booleanToByte(Boolean value) {
        return (null != value && value) ? (byte) 1 : (byte) 0;
    }

    public Byte booleanToByte(boolean value) {
        return value ? (byte) 1 : (byte) 0;
    }
}
