package com.bxm.newidea.component.tools;

import cn.hutool.core.date.LocalDateTimeUtil;

import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * @author liujia
 */
public class CronUtil {
    private CronUtil() {
    }

    private static DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("ss mm HH dd MM ?");

    /**
     * 根据启动时间获取cron表达式（只执行一次）
     *
     * @param date 启动时间
     * @return cron表达式
     */
    public static String formatDateToCron(Date date) {
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = dateFormat.format(LocalDateTimeUtil.of(date));
        }
        return formatTimeStr;
    }

}
