package com.bxm.newidea.component.tools;

import lombok.experimental.UtilityClass;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;

/**
 * @author liujia
 * @date 6/7/21 4:00 PM
 **/
@UtilityClass
public class LocalDateUtils {

    public static final ZoneId DEFAULT_ZONE_ID = ZoneId.of("GMT+8");

    public static LocalDate toLocalDate(Date date) {
        if (null == date) {
            return null;
        }

        Instant instant = date.toInstant();
        return instant.atZone(DEFAULT_ZONE_ID).toLocalDate();
    }
}
