/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.bo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Message
implements Serializable {
    private static final long serialVersionUID = -4550277881300593979L;
    private boolean success = true;
    private String bizCode;
    private List<String> messages = Lists.newArrayList();
    private Map<String, Object> paramMap = Maps.newHashMap();

    private Message() {
        this.setDefaultMessage();
    }

    private Message(boolean success) {
        this.success = success;
        this.setDefaultMessage();
    }

    private Message(boolean success, String content) {
        if (StringUtils.isNotBlank((CharSequence)content)) {
            this.messages.add(content);
        } else {
            this.setDefaultMessage();
        }
        this.success = success;
    }

    private Message(Message message) {
        this.append(message);
    }

    public static Message build() {
        return new Message();
    }

    public static Message build(boolean success) {
        return new Message(success);
    }

    public static Message build(int result, String successMsg, String failMsg) {
        return Message.build(result > 0, successMsg, failMsg);
    }

    public static Message build(boolean success, String successMsg, String failMsg) {
        Message message = new Message(success);
        if (success) {
            message.setMessage(successMsg);
        } else {
            message.setMessage(failMsg);
        }
        return message;
    }

    public static Message build(int result) {
        return new Message(result > 0);
    }

    public static Message build(boolean success, String msg) {
        return new Message(success, msg);
    }

    public static Message build(Message message) {
        return new Message(message);
    }

    private void setDefaultMessage() {
        if (this.success) {
            this.messages.add("\u8bf7\u6c42\u5904\u7406\u5b8c\u6210");
        } else {
            this.messages.add("\u64cd\u4f5c\u5931\u8d25");
        }
    }

    public Message append(Message message) {
        if (null != message) {
            if (!message.isSuccess()) {
                this.success = message.isSuccess();
                this.messages.addAll(message.messages);
            }
            this.paramMap.putAll(message.getParamMap());
        }
        return this;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Message setSuccess(boolean success) {
        if (this.success) {
            this.success = success;
        }
        return this;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public String getLastMessage() {
        if (this.messages.size() > 0) {
            return this.messages.get(this.messages.size() - 1);
        }
        return "";
    }

    public Message setMessage(String message) {
        this.messages.add(message);
        return this;
    }

    public Message addParam(String key, Object value) {
        this.paramMap.put(key, value);
        return this;
    }

    public <T> T getParam(String key) {
        Object obj = this.paramMap.get(key);
        if (obj == null) {
            return null;
        }
        return (T)obj;
    }

    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    public String getBizCode() {
        return this.bizCode;
    }

    public Message setBizCode(String bizCode) {
        this.bizCode = bizCode;
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("\u64cd\u4f5c\u7ed3\u679c\uff1a[").append(this.success).append("],");
        result.append("\u4e1a\u52a1\u72b6\u6001\uff1a[").append(this.bizCode).append("],");
        result.append("\u8fd4\u56de\u6d88\u606f\uff1a[");
        for (String content : this.messages) {
            result.append(content).append(" ");
        }
        result.append("]");
        return result.toString();
    }
}

