package com.bxm.newidea.component.tools;


import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.util.HashSet;

import static org.apache.commons.lang.StringUtils.isBlank;

/**
 * 随机相关的工具类
 *
 * @author liujia 2018/4/28 15:23
 */
public class RandomUtils extends org.apache.commons.lang3.RandomUtils {

    private static char[] SHORT_CODE = "0123456789".toCharArray();

    private static SecureRandom random = new SecureRandom();

    /**
     * 获取一个纯数字的随机字符串
     *
     * @param length 生成字符串长度
     * @return 生成结果
     */
    public static String getShortCode(int length) {
        StringBuilder strValue = new StringBuilder();
        for (int i = 0; i < length; i++) {
            int index = nextInt(0, 9);
            strValue.append(SHORT_CODE[index % SHORT_CODE.length]);
        }
        return strValue.toString();
    }

    /**
     * 获得一个随机的字符串
     *
     * @param length 随机字符串的长度
     * @param noCase true表示不区分大小写
     * @return 随机字符串
     */
    public static String getRandomStr(int length, boolean noCase) {
        StringBuilder randomStr = new StringBuilder();

        char[] samplerArray = noCase ? StringUtils.DIGITS_NOCASE : StringUtils.DIGITS;
        int randSeed = samplerArray.length;

        for (int i = 0; i < length; i++) {
            randomStr.append(samplerArray[nextInt(0, randSeed)]);
        }

        return randomStr.toString();
    }

    public static Integer getRandomTime(String str) {
        if (isBlank(str)) {
            return 0;
        } else {
            String[] array = str.split("~");
            return random.nextInt(Integer.valueOf(array[1]) - Integer.valueOf(array[0]) + 1) + Integer.valueOf(array[0]);
        }
    }

    /**
     * 随机指定范围内N个不重复的数
     * 利用HashSet的特征，只能存放不同的值
     *
     * @param min 指定范围最小值
     * @param max 指定范围最大值
     * @param n   随机数个数
     * @param set 随机数结果集
     */
    public static void randomSet(int min, int max, int n, int total, HashSet<Integer> set) {
        if (n > (max - min + 1) || max < min) {
            return;
        }
        for (int i = 0; i < n; i++) {
            // 调用Math.random()方法
            int num = (int) (Math.random() * (max - min)) + min;
            // 将不同的数存入HashSet中
            set.add(num);
        }
        int setSize = set.size();
        // 如果存入的数小于指定生成的个数，则调用递归再生成剩余个数的随机数，如此循环，直到达到指定大小
        if (setSize < total) {
            // 递归
            randomSet(min, max, total - setSize, total, set);
        }
    }

    /**
     * 获取指定精度的double
     * 区间默认0 - double max
     *
     * @param scale
     * @return
     */
    public static double randomDouble(int scale) {
        return randomDouble(scale, 0, Double.MAX_VALUE);
    }

    /**
     * 获取指定区间，指定精度的double
     *
     * @param scale
     * @param start
     * @param end
     * @return
     */
    public static double randomDouble(int scale, double start, double end) {

        // 得到精度
        double scaleI = Math.pow(scale, 10);

        // 转为整形 直接截取
        long startL = (long) (start * scaleI);
        long endL = (long) (end * scaleI);

        // 取得区间的值
        BigDecimal res = BigDecimal.valueOf(nextLong(startL, endL))
                .divide(BigDecimal.valueOf(scaleI), scale, RoundingMode.HALF_DOWN);

        return res.doubleValue();
    }
}
