package com.bxm.newidea.component.dto;

import java.util.List;

/**
 * 分页模型接口，适配不同的第三方分页
 * 用于兼容之前版本代码，减少客户端、前端的代码修改
 *
 * @author liujia
 * @date 6/4/21 10:57 AM
 **/
public interface IPageModel<T> {
    /**
     * 获取当前页
     *
     * @return 当前第几页
     */
    int getPageNum();

    /**
     * 每页显示数量
     */
    int getPageSize();

    /**
     * 当前页获取的数据条数
     */
    int getSize();

    /**
     * 数据总量
     */
    int getTotal();

    /**
     * 总分页数
     */
    int getPages();

    /**
     * 当前页数据集合
     */
    List<T> getList();

    /**
     * 前一页页号
     */
    int getPrePage();

    /**
     * 下一页页号
     */
    int getNextPage();

    /**
     * 是否第一页
     */
    boolean isFirstPage();

    /**
     * 是否最后一页
     */
    boolean isLastPage();

    /**
     * 是否有上一页
     */
    boolean isHasPreviousPage();

    /**
     * 是否有下一页
     */
    boolean isHasNextPage();

    /**
     * 第一页页码
     */
    int getFirstPage();

    /**
     * 最后一页页码
     */
    int getLastPage();
}
