/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.tools;

import com.bxm.newidea.component.tools.Interval;
import com.bxm.newidea.component.tools.LocalDateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.tools.inner.IntervalMap;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final long WEEK_MILLISECOND = 604800000L;
    public static final long DAY_MILLISECOND = 86400000L;
    public static final long HOUR_MILLISECOND = 3600000L;
    public static final long MINUTE_MILLISECOND = 60000L;
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_TIME_COMPACT_FORMAT = "yyyyMMddHHmmss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_COMPACT_FORMAT = "yyyyMMdd";
    public static final String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DATE_WITH_HOUR_FORMAT = "yyyy-MM-dd HH";
    public static final String DATE_WITHOUT_DAY_FORMAT = "yyyyMM";
    public static final String DATE_FORMAT_DAY_HOUR_MUNITE = "yyyy-MM-dd HH:mm";
    public static final String DATE_FORMAT_YEAR_MONTH_DAY_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String DATE_FORMAT_MONTH_DAY_FORMAT = "MM\u6708dd\u65e5";
    public static final String DATE_TIME_SECONDMS_FORMAT = "yyyyMMddHHmmsssss";
    public static final String MONTH_DAY_FORMAT = "MM-dd";
    public static final String HOUR_MINUTE_FORMAT = "HH:mm";
    public static final String HOUR_MINUTE_SECOND_FORMAT = "HH:mm:ss";
    public static ThreadLocal<DateFormat> DATE_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_FORMAT));
    public static ThreadLocal<DateFormat> DATE_FORMAT_MONTH_DAY_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_FORMAT_MONTH_DAY_FORMAT));
    public static ThreadLocal<DateFormat> DATE_TIME_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_TIME_FORMAT));
    public static ThreadLocal<DateFormat> ISO_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat(ISO_FORMAT));
    public static ThreadLocal<DateFormat> DATE_HOUR_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_WITH_HOUR_FORMAT));
    public static ThreadLocal<DateFormat> DATE_TIME_SECOND_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_TIME_COMPACT_FORMAT));
    public static ThreadLocal<DateFormat> DATE_TIME_SECONDMS_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_TIME_SECONDMS_FORMAT));
    public static ThreadLocal<DateFormat> PATTERN_NO_DELIMITER_WITHOUT_DAY_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_WITHOUT_DAY_FORMAT));
    public static ThreadLocal<DateFormat> PATTERN_NO_DELIMITER_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_COMPACT_FORMAT));
    public static ThreadLocal<DateFormat> PATTERN_MONTH_DAY_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(MONTH_DAY_FORMAT));
    public static ThreadLocal<DateFormat> PATTERN_YEAR_MONTH_DAY_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_FORMAT_YEAR_MONTH_DAY_FORMAT));
    public static ThreadLocal<DateFormat> PATTERN_HOUR_MINUTE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(HOUR_MINUTE_FORMAT));
    public static ThreadLocal<DateFormat> PATTERN_HOUR_MINUTE_SECEND_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(HOUR_MINUTE_SECOND_FORMAT));
    private static List<ThreadLocal<DateFormat>> FORMAT_LIST = new ArrayList<ThreadLocal<DateFormat>>();

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        return DATE_FORMAT_THREAD_LOCAL.get().format(date);
    }

    public static String formatAtWill(Date source, String formatPatter) {
        if (null == source) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat(formatPatter);
        return format.format(source);
    }

    public static String formatDateNonStrict(Date date) {
        String result = null;
        if (null == date) {
            return null;
        }
        for (ThreadLocal<DateFormat> supportFormatLocal : FORMAT_LIST) {
            result = supportFormatLocal.get().format(date);
            if (!StringUtils.isNotBlank((CharSequence)result)) continue;
            return result;
        }
        return result;
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return DATE_TIME_FORMAT_THREAD_LOCAL.get().format(date);
    }

    public static Date parseDate(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        try {
            return DATE_FORMAT_THREAD_LOCAL.get().parse(source);
        }
        catch (ParseException e) {
            log.info(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Date parseDateNonStrict(String source) {
        if (null == source) {
            return null;
        }
        if (NumberUtils.isDigits((String)source) && source.length() == 13) {
            return new Date(Long.valueOf(source));
        }
        for (ThreadLocal<DateFormat> supportFormatLocal : FORMAT_LIST) {
            try {
                Date result = supportFormatLocal.get().parse(source);
                if (null == result) continue;
                return result;
            }
            catch (ParseException e) {
                log.info(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static Date parseDateTime(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        try {
            return DATE_TIME_FORMAT_THREAD_LOCAL.get().parse(source);
        }
        catch (ParseException e) {
            log.info(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Date parse(String source) {
        Date parseResult;
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        try {
            parseResult = DATE_TIME_FORMAT_THREAD_LOCAL.get().parse(source);
        }
        catch (ParseException e) {
            parseResult = null;
        }
        try {
            if (null == parseResult) {
                parseResult = DATE_FORMAT_THREAD_LOCAL.get().parse(source);
            }
        }
        catch (ParseException e) {
            log.info(e.getMessage(), (Throwable)e);
        }
        if (null == parseResult) {
            log.info("\u4e0d\u652f\u6301\u8be5\u683c\u5f0f\u7684\u65e5\u671f\u8f6c\u6362\uff0c\u6e90\u6570\u636e\u4e3a[{}]", (Object)source);
        }
        return parseResult;
    }

    public static String getCurrentDate() {
        return DateUtils.formatDate(new Date());
    }

    public static String getCurrentDateTime() {
        return DateUtils.formatDateTime(new Date());
    }

    public static Date getClearDate(Date date) {
        if (null == date) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.clearTimePart(calendar);
        return calendar.getTime();
    }

    public static boolean before(Date when) {
        return DateUtils.after(new Date(), when);
    }

    public static boolean after(Date when) {
        return DateUtils.after(when, new Date());
    }

    public static boolean before(Date source, Date target) {
        return DateUtils.after(target, source);
    }

    public static boolean after(Date source, Date target) {
        if (null == source || null == target) {
            return false;
        }
        Calendar sourceCalendar = Calendar.getInstance();
        sourceCalendar.setTime(source);
        return source.after(target);
    }

    public static Date addField(Date date, int field, int amount) {
        Calendar sourceCalendar = Calendar.getInstance();
        sourceCalendar.setTime(date);
        sourceCalendar.add(field, amount);
        return sourceCalendar.getTime();
    }

    public static int getField(Date date, int field) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(field);
    }

    public static Date setField(Date date, int field, int amount) {
        Calendar sourceCalendar = Calendar.getInstance();
        sourceCalendar.setTime(date);
        sourceCalendar.set(field, amount);
        return sourceCalendar.getTime();
    }

    public static int getDiffMonths(Date source, Date target) {
        if (null == source || null == target) {
            return 0;
        }
        Calendar sourceCalendar = Calendar.getInstance();
        sourceCalendar.setTime(source);
        Calendar targetCalendar = Calendar.getInstance();
        targetCalendar.setTime(target);
        int sourceYear = sourceCalendar.get(1);
        int sourceMonth = sourceCalendar.get(2);
        int targetYear = targetCalendar.get(1);
        int targetMonth = targetCalendar.get(2);
        int diffMonth = sourceYear * 12 + sourceMonth - (targetYear * 12 + targetMonth);
        return Math.abs(diffMonth);
    }

    public static int getDiffDays(Date source, Date target, boolean abs) {
        if (null == source || null == target) {
            return 0;
        }
        LocalDate sourceDate = LocalDateUtils.toLocalDate(source);
        LocalDate targetDate = LocalDateUtils.toLocalDate(target);
        long diffDays = sourceDate.toEpochDay() - targetDate.toEpochDay();
        if (abs) {
            return (int)Math.abs(diffDays);
        }
        return (int)diffDays;
    }

    public static long getDiffHours(Date source, Date target, boolean abs) {
        if (null == source || null == target) {
            return 0L;
        }
        long diffSecond = source.getTime() - target.getTime();
        if (abs) {
            diffSecond = Math.abs(diffSecond);
        }
        return Math.abs(diffSecond / 3600000L);
    }

    public static long getDiffMinutes(Date source, Date target) {
        return DateUtils.getDiffMinutes(source, target, true);
    }

    public static long getDiffMinutes(Date source, Date target, boolean abs) {
        if (null == source || null == target) {
            return 0L;
        }
        long diffSeconed = source.getTime() - target.getTime();
        if (abs) {
            diffSeconed = Math.abs(diffSeconed);
        }
        return diffSeconed / 60000L;
    }

    public static long getDiffSeconed(Date source, Date target, boolean abs) {
        if (null == source || null == target) {
            return 0L;
        }
        long diffSecond = (source.getTime() - target.getTime()) / 1000L;
        if (abs) {
            return Math.abs(diffSecond);
        }
        return diffSecond;
    }

    public static int getDiffYears(Date source, Date target) {
        if (null == source || null == target) {
            return 0;
        }
        Calendar sourceCalendar = Calendar.getInstance();
        sourceCalendar.setTime(source);
        Calendar targetCalendar = Calendar.getInstance();
        targetCalendar.setTime(target);
        int diffYears = targetCalendar.get(1) - sourceCalendar.get(1);
        diffYears = Math.abs(diffYears);
        if (targetCalendar.get(2) < sourceCalendar.get(2)) {
            --diffYears;
        } else if (targetCalendar.get(2) == sourceCalendar.get(2) && targetCalendar.get(5) < sourceCalendar.get(5)) {
            --diffYears;
        }
        return diffYears;
    }

    public static IntervalMap getInterval(Interval interval) {
        return DateUtils.getInterval(interval, new Date());
    }

    public static IntervalMap getInterval(Interval interval, Date date) {
        Date startTime = null;
        Date endTime = null;
        if (null == interval || null == date) {
            return new IntervalMap(null, null);
        }
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        switch (interval) {
            case TODAY: {
                startCalendar.setTime(date);
                endCalendar.setTime(date);
                endCalendar.add(6, 1);
                break;
            }
            case TOMORROW: {
                startCalendar.setTime(date);
                startCalendar.add(6, 1);
                endCalendar.setTime(date);
                endCalendar.add(6, 2);
                break;
            }
            case YESTERDAY: {
                startCalendar.setTime(date);
                startCalendar.add(6, -1);
                endCalendar.setTime(date);
                break;
            }
            case THREE_DAY: {
                startCalendar.setTime(date);
                startCalendar.add(6, -3);
                endCalendar.setTime(date);
                break;
            }
            case FIVE_DAY: {
                startCalendar.setTime(date);
                startCalendar.add(6, -5);
                endCalendar.setTime(date);
                break;
            }
            case SEVEN_DAY: {
                startCalendar.setTime(date);
                startCalendar.add(6, -7);
                endCalendar.setTime(date);
                break;
            }
            case WEEK: {
                boolean isSunday;
                startCalendar.setTime(date);
                boolean bl = isSunday = startCalendar.get(7) == 1;
                if (isSunday) {
                    startCalendar.add(3, -1);
                }
                startCalendar.set(7, 2);
                endCalendar.setTime(date);
                if (!isSunday) {
                    endCalendar.add(3, 1);
                }
                endCalendar.set(7, 1);
                break;
            }
            case MONTH: {
                startCalendar.setTime(date);
                startCalendar.set(5, 1);
                endCalendar.setTime(date);
                endCalendar.set(5, endCalendar.getActualMaximum(5));
                break;
            }
            case QUARTER: {
                startCalendar.setTime(date);
                endCalendar.setTime(date);
                int currentMonth = startCalendar.get(2);
                int startMonth = currentMonth % 3 * 3;
                int endMonth = startMonth + 2;
                startCalendar.set(2, startMonth);
                startCalendar.set(5, 1);
                endCalendar.set(2, endMonth);
                endCalendar.set(5, endCalendar.getActualMaximum(5));
                break;
            }
            case HALY_YEAR: {
                startCalendar.setTime(date);
                endCalendar.setTime(date);
                int currentMonth = startCalendar.get(2);
                int startMonth = currentMonth % 6 * 6;
                int endMonth = startMonth + 5;
                startCalendar.set(2, startMonth);
                startCalendar.set(5, 1);
                endCalendar.set(2, endMonth);
                endCalendar.set(5, endCalendar.getActualMaximum(5));
                break;
            }
            case YEAR: {
                startCalendar.setTime(date);
                startCalendar.set(2, 0);
                startCalendar.set(5, 1);
                endCalendar.setTime(date);
                endCalendar.set(2, 11);
                endCalendar.set(5, endCalendar.getActualMaximum(5));
                break;
            }
            case LAST_YEAR: {
                startCalendar.setTime(date);
                startCalendar.add(1, -1);
                startCalendar.set(2, 0);
                startCalendar.set(5, 1);
                endCalendar.setTime(date);
                endCalendar.add(1, -1);
                endCalendar.set(2, 11);
                endCalendar.set(5, endCalendar.getActualMaximum(5));
                break;
            }
            default: {
                return new IntervalMap(startTime, endTime);
            }
        }
        DateUtils.clearTimePart(startCalendar);
        DateUtils.clearTimePart(endCalendar);
        startTime = startCalendar.getTime();
        endTime = endCalendar.getTime();
        return new IntervalMap(startTime, endTime);
    }

    public static void clearTimePart(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static Date clearTimePart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.clearTimePart(calendar);
        return calendar.getTime();
    }

    public static long getTodayEndMillis() {
        Date now = new Date();
        return DateUtils.getDayEndTime(null).getTime() - now.getTime();
    }

    public static int getCurSeconds() {
        return (int)(DateUtils.getTodayEndMillis() / 1000L);
    }

    public static Date getDayEndTime(Date date) {
        Calendar instance = Calendar.getInstance();
        if (Objects.nonNull(date)) {
            instance.setTime(date);
        }
        instance.set(11, 23);
        instance.set(12, 59);
        instance.set(13, 59);
        instance.set(14, 999);
        return instance.getTime();
    }

    public static boolean isSameDay(Date resource, Date target) {
        if (resource != null && target != null) {
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(resource);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(target);
            return DateUtils.isSameDay(cal1, cal2);
        }
        return false;
    }

    public static boolean isToday(Date target) {
        return DateUtils.isSameDay(new Date(), target);
    }

    private static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 != null && cal2 != null) {
            return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
        }
        return false;
    }

    private DateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        FORMAT_LIST.add(DATE_TIME_FORMAT_THREAD_LOCAL);
        FORMAT_LIST.add(DATE_FORMAT_THREAD_LOCAL);
        FORMAT_LIST.add(ISO_FORMAT_THREAD_LOCAL);
        FORMAT_LIST.add(DATE_TIME_SECONDMS_FORMAT_THREAD_LOCAL);
        FORMAT_LIST.add(DATE_TIME_SECOND_FORMAT_THREAD_LOCAL);
        FORMAT_LIST.add(DATE_HOUR_FORMAT_THREAD_LOCAL);
    }
}

